/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 11/27/2006 : Version 1.0
* Description        : main program for Memory to Memory DMA example.
********************************************************************************
* History:
* 11/27/2006 : Version 1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/


/* Standard include ----------------------------------------------------------*/
#include "91x_lib.h"


/* Include of other module interface headers ---------------------------------*/
/* Local includes ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

DMA_InitTypeDef  DMA_InitStruct;
GPIO_InitTypeDef GPIO_InitStructure;

/* Src_Buffer to be transfered to Dest_Buffer*/
u32 Src_Buffer[8] ={1,2,3,4,5,6,7,8};

/* The Destination buffer*/
u32 Dest_Buffer[8] ={0,0,0,0,0,0,0,0};

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void main(void)
{


  #ifdef DEBUG
  debug();
  #endif
  
  /******************************VIC configuration*****************************/
  
  /*Enable VIC clock*/
  SCU_AHBPeriphClockConfig(__VIC,ENABLE); 
  
  SCU_AHBPeriphReset(__VIC,DISABLE); 
  VIC_DeInit();
  VIC_Config(DMA_ITLine, VIC_IRQ, 0);
  VIC_ITCmd(DMA_ITLine, ENABLE);
  /****************************************************************************/
 
  /*Enable DMA clock*/
  SCU_AHBPeriphClockConfig(__DMA, ENABLE);
  
  /* DMA default configuration : Reset configuration*/
  DMA_DeInit(); 
  
  /*Enable the DMA*/
  DMA_Cmd(ENABLE);                                             
  DMA_StructInit(&DMA_InitStruct);

  /*******************************DMA configuration ***************************/
  
  /*No use of linked lists*/
  DMA_InitStruct.DMA_Channel_LLstItm=0;
  
  /* Source address */
  DMA_InitStruct.DMA_Channel_SrcAdd=((u32)&Src_Buffer[0]);
  
  /*Destination address  */
  DMA_InitStruct.DMA_Channel_DesAdd=((u32)&Dest_Buffer[0]);
  
  /* The source bus width is a word" 32 bits"*/
  DMA_InitStruct.DMA_Channel_SrcWidth= DMA_SrcWidth_Word;
  
  /* The Destination bus width is a word word*/
  DMA_InitStruct.DMA_Channel_DesWidth= DMA_DesWidth_Word; 
  
  /*DMA burst size of 8 data*/
  DMA_InitStruct.DMA_Channel_DesBstSize = DMA_DesBst_8Data ; 
  DMA_InitStruct.DMA_Channel_SrcBstSize = DMA_SrcBst_8Data ;
   
  /* DMA is The flow controller*/
  DMA_InitStruct.DMA_Channel_FlowCntrl=  DMA_FlowCntrlt0_DMA;
  
  /*Transfer size of 8 data*/
  DMA_InitStruct.DMA_Channel_TrsfSize =8; 
  
  /* Configure the DMA channel1 "the chosen channel to perform the transfer" */
  DMA_ChannelSRCIncConfig (DMA_Channel1, ENABLE);
  DMA_ChannelDESIncConfig (DMA_Channel1, ENABLE);
  
  /*Enable the terminal count interrupt for the first LLI*/
  DMA_ITConfig(DMA_Channel1, ENABLE);
  
  /*Enable the terminal count interrupt for the channel1*/
  DMA_ITMaskConfig(DMA_Channel1, DMA_ITMask_ITC, ENABLE);
  
  /* Update the DMA channel1 registers */
  DMA_Init(DMA_Channel1,&DMA_InitStruct);
  
  /*Enable the DMA channel*/
  DMA_ChannelCmd (DMA_Channel1,ENABLE);
  while(1);

}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
